/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.camera;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.messaging.types.MouseChangeMessage;

@Singleton
public class PrimaryCameraWrapper
implements GameContextAware {
    private static final float XY_MOVEMENT_SPEED = 4.0f;
    public static final float ZOOM_SPEED = 10.0f;
    private final OrthographicCamera camera;
    private Vector3 xyzVelocity = new Vector3();
    private float targetZoom;
    private int worldWidth;
    private int worldHeight;
    private final MessageDispatcher messageDispatcher;

    @Inject
    public PrimaryCameraWrapper(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, (float)Gdx.graphics.getWidth() / 100.0f, (float)Gdx.graphics.getHeight() / 100.0f);
        this.camera.zoom = 2.0f;
        this.targetZoom = 2.0f;
    }

    public void zoom(int zoomAmount) {
        this.targetZoom = this.camera.zoom + this.camera.zoom * (float)zoomAmount * 0.5f;
        if (this.targetZoom < 1.0f) {
            this.targetZoom = 1.0f;
        } else if (this.targetZoom > 6.0f) {
            this.targetZoom = 6.0f;
        }
    }

    public void update(float deltaSeconds) {
        this.camera.position.x += this.xyzVelocity.x * deltaSeconds * 4.0f * this.camera.zoom;
        if (this.camera.position.x < 0.0f) {
            this.camera.position.x = 0.0f;
        } else if (this.camera.position.x > (float)this.worldWidth) {
            this.camera.position.x = this.worldWidth;
        }
        this.camera.position.y += this.xyzVelocity.y * deltaSeconds * 4.0f * this.camera.zoom;
        if (this.camera.position.y < 0.0f) {
            this.camera.position.y = 0.0f;
        } else if (this.camera.position.y > (float)this.worldHeight) {
            this.camera.position.y = this.worldHeight;
        }
        if (this.xyzVelocity.z != 0.0f) {
            this.camera.zoom += this.xyzVelocity.z * deltaSeconds * 4.0f * this.camera.zoom;
            this.targetZoom = this.camera.zoom;
        } else {
            float difference;
            if (this.camera.zoom < this.targetZoom) {
                difference = this.targetZoom - this.camera.zoom;
                this.camera.zoom = difference < 0.05f ? this.targetZoom : (this.camera.zoom += 10.0f * deltaSeconds * difference);
            }
            if (this.camera.zoom > this.targetZoom) {
                difference = this.camera.zoom - this.targetZoom;
                this.camera.zoom = difference < 0.05f ? this.targetZoom : (this.camera.zoom -= 10.0f * deltaSeconds * difference);
            }
        }
        this.camera.update();
        if (!this.xyzVelocity.isZero() || this.camera.zoom != this.targetZoom) {
            int screenX = Gdx.input.getX();
            int screenY = Gdx.input.getY();
            Vector3 cursorPosition = this.camera.unproject(new Vector3(screenX, screenY, 0.0f));
            this.messageDispatcher.dispatchMessage(203, new MouseChangeMessage(screenX, screenY, new Vector2(cursorPosition.x, cursorPosition.y), null));
        }
    }

    public void init(TiledMap areaMap) {
        this.camera.zoom = 2.0f;
        this.targetZoom = 2.0f;
        this.worldWidth = areaMap.getWidth();
        this.worldHeight = areaMap.getHeight();
        this.camera.position.x = this.worldWidth / 2;
        this.camera.position.y = this.worldHeight / 2;
        this.moveTo(areaMap.getEmbarkPoint());
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public void setMovementX(float amount) {
        this.xyzVelocity.x = amount;
    }

    public void setMovementY(float amount) {
        this.xyzVelocity.y = amount;
    }

    public void setMovementZ(float amount) {
        this.xyzVelocity.z = amount;
    }

    public void onResize(int width, int height) {
        float tempX = this.camera.position.x;
        float tempY = this.camera.position.y;
        float zoom = this.camera.zoom;
        this.camera.setToOrtho(false, (float)width / 100.0f, (float)height / 100.0f);
        this.camera.position.x = tempX;
        this.camera.position.y = tempY;
        this.camera.zoom = zoom;
    }

    public void moveTo(GridPoint2 tilePosition) {
        this.camera.position.x = (float)tilePosition.x + 0.5f;
        this.camera.position.y = (float)tilePosition.y + 0.5f;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        if (gameContext != null) {
            this.init(gameContext.getAreaMap());
        }
    }
}

